/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ResetableTimer {
    private volatile boolean running;
    private Thread boss;
    private ExecutorService threadPool;
    private Runnable task;
    private int period;
    protected long lastTime;

    public ResetableTimer(int periodMillisecond) {
        this(periodMillisecond, null);
    }

    public ResetableTimer(int periodMillisecond, Runnable task) {
        this.period = periodMillisecond;
        this.delay(0 - this.period);
        this.setTask(task);
        this.threadPool = Executors.newSingleThreadExecutor();
    }

    public void setTask(Runnable task) {
        this.task = task;
    }

    public void start() {
        if (this.boss != null) {
            return;
        }
        this.running = true;
        this.boss = new Thread(new Runnable(){

            public void run() {
                while (ResetableTimer.this.running) {
                    long split = System.currentTimeMillis() - ResetableTimer.this.lastTime;
                    if (split >= (long)ResetableTimer.this.period && ResetableTimer.this.task != null) {
                        try {
                            ResetableTimer.this.threadPool.execute(ResetableTimer.this.task);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ResetableTimer.this.delay();
                    }
                    try {
                        Thread.sleep(split >= (long)ResetableTimer.this.period ? (long)ResetableTimer.this.period : (long)ResetableTimer.this.period - split);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        this.boss.start();
    }

    public void stop() throws InterruptedException {
        this.running = false;
        this.boss.join();
        this.boss = null;
        this.threadPool.shutdown();
    }

    public void delay() {
        this.delay(0);
    }

    public void delay(int delayMillisecond) {
        this.lastTime = System.currentTimeMillis() + (long)delayMillisecond;
    }
}

