/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.embedded.websocket.impl;

import com.taobao.top.link.embedded.websocket.WebSocket;
import com.taobao.top.link.embedded.websocket.exception.ErrorCode;
import com.taobao.top.link.embedded.websocket.exception.WebSocketException;
import com.taobao.top.link.embedded.websocket.frame.Frame;
import com.taobao.top.link.embedded.websocket.frame.FrameHeader;
import com.taobao.top.link.embedded.websocket.frame.FrameParser;
import com.taobao.top.link.embedded.websocket.frame.draft06.BinaryFrame;
import com.taobao.top.link.embedded.websocket.frame.draft06.CloseFrame;
import com.taobao.top.link.embedded.websocket.frame.draft06.FrameBuilderDraft06;
import com.taobao.top.link.embedded.websocket.frame.draft06.FrameHeaderDraft06;
import com.taobao.top.link.embedded.websocket.frame.draft06.TextFrame;
import com.taobao.top.link.embedded.websocket.handler.MaskDraft06FrameStreamHandler;
import com.taobao.top.link.embedded.websocket.handler.StreamHandlerAdapter;
import com.taobao.top.link.embedded.websocket.handler.StreamHandlerChain;
import com.taobao.top.link.embedded.websocket.handler.WebSocketHandler;
import com.taobao.top.link.embedded.websocket.handler.WebSocketPipeline;
import com.taobao.top.link.embedded.websocket.handshake.Handshake;
import com.taobao.top.link.embedded.websocket.impl.WebSocketBase;
import com.taobao.top.link.embedded.websocket.proxy.Proxy;
import com.taobao.top.link.embedded.websocket.util.Base64;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class WebSocketDraft06
extends WebSocketBase {
    private static final int VERSION = 6;
    protected Set<String> extensions = new HashSet<String>();
    protected String[] serverExtentions;

    public WebSocketDraft06(String url, String origin, WebSocketHandler handler, String ... protocols) throws WebSocketException {
        super(url, origin, handler, protocols);
    }

    public WebSocketDraft06(String url, WebSocketHandler handler, String ... protocols) throws WebSocketException {
        super(url, handler, protocols);
    }

    public WebSocketDraft06(String url, String origin, Proxy proxy, WebSocketHandler handler, String ... protocols) throws WebSocketException {
        super(url, origin, proxy, handler, protocols);
    }

    public WebSocketDraft06(String url, Proxy proxy, WebSocketHandler handler, String ... protocols) throws WebSocketException {
        super(url, proxy, handler, protocols);
    }

    protected void initializePipeline(WebSocketPipeline pipeline) throws WebSocketException {
        pipeline.addStreamHandler(new MaskDraft06FrameStreamHandler());
        super.initializePipeline(pipeline);
        pipeline.addStreamHandler(new StreamHandlerAdapter(){

            public void nextDownstreamHandler(WebSocket ws, ByteBuffer buffer, Frame frame, StreamHandlerChain chain) throws WebSocketException {
                if (frame instanceof CloseFrame) {
                    if (WebSocketDraft06.this.state == WebSocketBase.State.WAIT) {
                        chain.nextUpstreamHandler(ws, null, frame);
                    }
                    WebSocketDraft06.this.transitionTo(WebSocketBase.State.CLOSED);
                } else {
                    WebSocketDraft06.this.handler.onMessage(ws, frame);
                }
            }

            public void nextHandshakeDownstreamHandler(WebSocket ws, ByteBuffer buffer, StreamHandlerChain chain) throws WebSocketException {
                WebSocketDraft06.this.responseHeader = WebSocketDraft06.this.getHandshake().getResponseHeader();
                WebSocketDraft06.this.responseStatus = WebSocketDraft06.this.getHandshake().getResponseStatus();
                WebSocketDraft06.this.transitionTo(WebSocketBase.State.WAIT);
                WebSocketDraft06.this.handler.onOpen(WebSocketDraft06.this);
            }
        });
    }

    protected Handshake newHandshakeInstance() {
        return new Handshake(){

            public ByteBuffer createHandshakeRequest() throws WebSocketException {
                StringBuilder sb = new StringBuilder();
                sb.append("GET " + WebSocketDraft06.this.path + " HTTP/1.1\r\n");
                WebSocketBase.addHeader(sb, "Host", WebSocketDraft06.this.endpointAddress.getHostName());
                WebSocketBase.addHeader(sb, "Upgrade", "websocket");
                WebSocketBase.addHeader(sb, "Connection", "Upgrade");
                WebSocketBase.addHeader(sb, "Sec-WebSocket-Key", WebSocketDraft06.this.generateWebSocketKey());
                if (WebSocketDraft06.this.origin != null) {
                    WebSocketBase.addHeader(sb, "Sec-WebSocket-Origin", WebSocketDraft06.this.origin);
                }
                if (WebSocketDraft06.this.protocols != null && WebSocketDraft06.this.protocols.length > 0) {
                    WebSocketBase.addHeader(sb, "Sec-WebSocket-Protocol", WebSocketBase.join(",", WebSocketDraft06.this.protocols));
                }
                if (WebSocketDraft06.this.extensions.size() > 0) {
                    WebSocketBase.addHeader(sb, "Sec-WebSocket-Extensions", WebSocketBase.join(",", WebSocketDraft06.this.extensions));
                }
                WebSocketBase.addHeader(sb, "Sec-WebSocket-Version", String.valueOf(WebSocketDraft06.this.getWebSocketVersion()));
                sb.append("\r\n");
                return ByteBuffer.wrap(sb.toString().getBytes());
            }

            protected boolean parseHandshakeResponseHeader(ByteBuffer buffer) throws WebSocketException {
                String extensionsStr;
                if (!super.parseHandshakeResponseHeader(buffer)) {
                    return false;
                }
                if (!"websocket".equalsIgnoreCase(this.getResponseHeader().getHeaderValue("upgrade"))) {
                    throw new WebSocketException(ErrorCode.E3600, WebSocketDraft06.this.responseHeader.getHeaderValue("upgrade"));
                }
                if (!"upgrade".equalsIgnoreCase(this.getResponseHeader().getHeaderValue("connection"))) {
                    throw new WebSocketException(ErrorCode.E3601, WebSocketDraft06.this.responseHeader.getHeaderValue("connection"));
                }
                if (!this.getResponseHeader().containsHeader("sec-websocket-accept")) {
                    throw new WebSocketException(ErrorCode.E3602);
                }
                String protocolStr = this.getResponseHeader().getHeaderValue("sec-websocket-protocol");
                if (protocolStr != null) {
                    WebSocketDraft06.this.serverProtocols = protocolStr.split(",");
                }
                if ((extensionsStr = this.getResponseHeader().getHeaderValue("sec-websocket-extensions")) != null) {
                    WebSocketDraft06.this.serverExtentions = extensionsStr.split(",");
                }
                return true;
            }
        };
    }

    private String generateWebSocketKey() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return Base64.encodeToString(md.digest(UUID.randomUUID().toString().getBytes()), false);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    protected FrameParser newFrameParserInstance() {
        return new FrameParser(){
            private FrameHeaderDraft06 previousCreatedFrameHeader;

            protected FrameHeader createFrameHeader(ByteBuffer chunkData) {
                FrameHeaderDraft06 header = FrameBuilderDraft06.createFrameHeader(chunkData, this.previousCreatedFrameHeader);
                if (!header.isContinuation()) {
                    this.previousCreatedFrameHeader = header;
                }
                return header;
            }

            protected Frame createFrame(FrameHeader h, byte[] bodyData) {
                return FrameBuilderDraft06.createFrame((FrameHeaderDraft06)h, bodyData);
            }
        };
    }

    public Frame createFrame(byte[] bytes) throws WebSocketException {
        return new BinaryFrame(bytes);
    }

    public Frame createFrame(String str) throws WebSocketException {
        return new TextFrame(str);
    }

    protected int getWebSocketVersion() {
        return 6;
    }

    public void addExtension(String extension) {
        this.extensions.add(extension);
    }

    public void removeExtension(String extension) {
        this.extensions.remove(extension);
    }

    protected void closeWebSocket() throws WebSocketException {
        this.transitionTo(WebSocketBase.State.CLOSING);
        this.pipeline.sendUpstream(this, null, new CloseFrame());
    }
}

