/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.types.ResolvedArrayType;
import com.fasterxml.classmate.types.ResolvedObjectType;
import com.fasterxml.classmate.types.ResolvedPrimitiveType;
import com.google.common.base.Optional;
import java.lang.reflect.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.plugin.core.Plugin;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.DefaultTypeNameProvider;
import springfox.documentation.schema.ModelNameContext;
import springfox.documentation.schema.Types;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.TypeNameProviderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
public class TypeNameExtractor {
    private final TypeResolver typeResolver;
    private final PluginRegistry<TypeNameProviderPlugin, DocumentationType> typeNameProviders;

    @Autowired
    public TypeNameExtractor(TypeResolver typeResolver, @Qualifier(value="typeNameProviderPluginRegistry") PluginRegistry<TypeNameProviderPlugin, DocumentationType> typeNameProviders) {
        this.typeResolver = typeResolver;
        this.typeNameProviders = typeNameProviders;
    }

    public String typeName(ModelContext context) {
        ResolvedType type = this.asResolved(context.getType());
        if (Collections.isContainerType(type)) {
            return Collections.containerType(type);
        }
        return this.innerTypeName(type, context);
    }

    private ResolvedType asResolved(Type type) {
        return this.typeResolver.resolve(type, new Type[0]);
    }

    private String genericTypeName(ResolvedType resolvedType, ModelContext context) {
        Class erasedType = resolvedType.getErasedType();
        GenericTypeNamingStrategy namingStrategy = context.getGenericNamingStrategy();
        ModelNameContext nameContext = new ModelNameContext(resolvedType.getErasedType(), context.getDocumentationType());
        String simpleName = (String)Optional.fromNullable((Object)Types.typeNameFor(erasedType)).or((Object)this.typeName(nameContext));
        StringBuilder sb = new StringBuilder(String.format("%s%s", simpleName, namingStrategy.getOpenGeneric()));
        boolean first = true;
        for (int index = 0; index < erasedType.getTypeParameters().length; ++index) {
            ResolvedType typeParam = (ResolvedType)resolvedType.getTypeParameters().get(index);
            if (first) {
                sb.append(this.innerTypeName(typeParam, context));
                first = false;
                continue;
            }
            sb.append(String.format("%s%s", namingStrategy.getTypeListDelimiter(), this.innerTypeName(typeParam, context)));
        }
        sb.append(namingStrategy.getCloseGeneric());
        return sb.toString();
    }

    private String innerTypeName(ResolvedType type, ModelContext context) {
        if (type.getTypeParameters().size() > 0 && type.getErasedType().getTypeParameters().length > 0) {
            return this.genericTypeName(type, context);
        }
        return this.simpleTypeName(type, context);
    }

    private String simpleTypeName(ResolvedType type, ModelContext context) {
        String typeName;
        Class erasedType = type.getErasedType();
        if (type instanceof ResolvedPrimitiveType) {
            return Types.typeNameFor(erasedType);
        }
        if (erasedType.isEnum()) {
            return "string";
        }
        if (type instanceof ResolvedArrayType) {
            GenericTypeNamingStrategy namingStrategy = context.getGenericNamingStrategy();
            return String.format("Array%s%s%s", namingStrategy.getOpenGeneric(), this.simpleTypeName(type.getArrayElementType(), context), namingStrategy.getCloseGeneric());
        }
        if (type instanceof ResolvedObjectType && (typeName = Types.typeNameFor(erasedType)) != null) {
            return typeName;
        }
        return this.typeName(new ModelNameContext(type.getErasedType(), context.getDocumentationType()));
    }

    private String typeName(ModelNameContext context) {
        TypeNameProviderPlugin selected = (TypeNameProviderPlugin)this.typeNameProviders.getPluginFor((Object)context.getDocumentationType(), (Plugin)new DefaultTypeNameProvider());
        return selected.nameFor(context.getType());
    }
}

