/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached;

import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.exception.MemcachedClientException;
import net.rubyeye.xmemcached.exception.MemcachedException;

public final class Counter {
    private final MemcachedClient memcachedClient;
    private final String key;
    private final long initialValue;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.memcachedClient == null ? 0 : this.memcachedClient.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Counter other = (Counter)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.memcachedClient == null ? other.memcachedClient != null : !this.memcachedClient.equals(other.memcachedClient));
    }

    public final String getKey() {
        return this.key;
    }

    public long get() throws MemcachedException, InterruptedException, TimeoutException {
        Object result = this.memcachedClient.get(this.key);
        if (result == null) {
            throw new MemcachedClientException("key is not existed.");
        }
        if (result instanceof Long) {
            return (Long)result;
        }
        return Long.valueOf(((String)result).trim());
    }

    public void set(long value) throws MemcachedException, InterruptedException, TimeoutException {
        this.memcachedClient.set(this.key, 0, String.valueOf(value));
    }

    public Counter(MemcachedClient memcachedClient, String key, long initialValue) {
        this.memcachedClient = memcachedClient;
        this.key = key;
        this.initialValue = initialValue;
        try {
            this.memcachedClient.add(key, 0, String.valueOf(this.initialValue));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new IllegalStateException("Initialize counter failed", e);
        }
    }

    public long incrementAndGet() throws MemcachedException, InterruptedException, TimeoutException {
        return this.memcachedClient.incr(this.key, 1L, this.initialValue);
    }

    public long decrementAndGet() throws MemcachedException, InterruptedException, TimeoutException {
        return this.memcachedClient.decr(this.key, 1L, this.initialValue);
    }

    public long addAndGet(long delta) throws MemcachedException, InterruptedException, TimeoutException {
        if (delta >= 0L) {
            return this.memcachedClient.incr(this.key, delta, this.initialValue);
        }
        return this.memcachedClient.decr(this.key, -delta, this.initialValue);
    }
}

