/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.buffer;

import com.google.code.yanf4j.util.CircularQueue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import net.rubyeye.xmemcached.buffer.BufferAllocator;
import net.rubyeye.xmemcached.buffer.IoBuffer;
import net.rubyeye.xmemcached.utils.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CachedBufferAllocator
implements BufferAllocator {
    private static final int DEFAULT_MAX_POOL_SIZE = 8;
    private static final int DEFAULT_MAX_CACHED_BUFFER_SIZE = 262144;
    private final int maxPoolSize;
    private final int maxCachedBufferSize;
    private final ThreadLocal<Map<Integer, Queue<CachedIoBuffer>>> heapBuffers;
    private final IoBuffer EMPTY_IO_BUFFER = new CachedIoBuffer(ByteBuffer.allocate(0));

    public CachedBufferAllocator() {
        this(8, 262144);
    }

    public CachedBufferAllocator(int maxPoolSize, int maxCachedBufferSize) {
        if (maxPoolSize < 0) {
            throw new IllegalArgumentException("maxPoolSize: " + maxPoolSize);
        }
        if (maxCachedBufferSize < 0) {
            throw new IllegalArgumentException("maxCachedBufferSize: " + maxCachedBufferSize);
        }
        this.maxPoolSize = maxPoolSize;
        this.maxCachedBufferSize = maxCachedBufferSize;
        this.heapBuffers = new ThreadLocal<Map<Integer, Queue<CachedIoBuffer>>>(){

            @Override
            protected Map<Integer, Queue<CachedIoBuffer>> initialValue() {
                return CachedBufferAllocator.this.newPoolMap();
            }
        };
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getMaxCachedBufferSize() {
        return this.maxCachedBufferSize;
    }

    private Map<Integer, Queue<CachedIoBuffer>> newPoolMap() {
        HashMap<Integer, Queue<CachedIoBuffer>> poolMap = new HashMap<Integer, Queue<CachedIoBuffer>>();
        int poolSize = this.maxPoolSize == 0 ? 8 : this.maxPoolSize;
        for (int i = 0; i < 31; ++i) {
            poolMap.put(1 << i, new CircularQueue(poolSize));
        }
        poolMap.put(0, new CircularQueue(poolSize));
        poolMap.put(Integer.MAX_VALUE, new CircularQueue(poolSize));
        return poolMap;
    }

    @Override
    public final IoBuffer allocate(int requestedCapacity) {
        IoBuffer buf;
        if (requestedCapacity == 0) {
            return this.EMPTY_IO_BUFFER;
        }
        int actualCapacity = ByteUtils.normalizeCapacity(requestedCapacity);
        if (this.maxCachedBufferSize != 0 && actualCapacity > this.maxCachedBufferSize) {
            buf = this.wrap(ByteBuffer.allocate(actualCapacity));
        } else {
            Queue<CachedIoBuffer> pool = this.heapBuffers.get().get(actualCapacity);
            buf = pool.poll();
            if (buf != null) {
                buf.clear();
            } else {
                buf = this.wrap(ByteBuffer.allocate(actualCapacity));
            }
        }
        buf.limit(requestedCapacity);
        return buf;
    }

    @Override
    public final IoBuffer wrap(ByteBuffer nioBuffer) {
        return new CachedIoBuffer(nioBuffer);
    }

    @Override
    public void dispose() {
        this.heapBuffers.remove();
    }

    public static BufferAllocator newInstance() {
        return new CachedBufferAllocator();
    }

    public static BufferAllocator newInstance(int maxPoolSize, int maxCachedBufferSize) {
        return new CachedBufferAllocator(maxPoolSize, maxCachedBufferSize);
    }

    public class CachedIoBuffer
    implements IoBuffer {
        Thread ownerThread = Thread.currentThread();
        ByteBuffer origBuffer;

        public CachedIoBuffer(ByteBuffer origBuffer) {
            this.origBuffer = origBuffer;
        }

        public void putInt(int i) {
            this.origBuffer.putInt(i);
        }

        public void putShort(short s) {
            this.origBuffer.putShort(s);
        }

        public ByteOrder order() {
            return this.origBuffer.order();
        }

        public boolean isDirect() {
            return this.origBuffer.isDirect();
        }

        public void order(ByteOrder byteOrder) {
            this.origBuffer.order(byteOrder);
        }

        public void putLong(long l) {
            this.origBuffer.putLong(l);
        }

        public final void free() {
            if (this.origBuffer == null || this.origBuffer.capacity() > CachedBufferAllocator.this.maxCachedBufferSize || Thread.currentThread() != this.ownerThread) {
                return;
            }
            Queue pool = (Queue)((Map)CachedBufferAllocator.this.heapBuffers.get()).get(this.origBuffer.capacity());
            if (pool == null) {
                return;
            }
            if (CachedBufferAllocator.this.maxPoolSize == 0 || pool.size() < CachedBufferAllocator.this.maxPoolSize) {
                pool.offer(new CachedIoBuffer(this.origBuffer));
            }
            this.origBuffer = null;
        }

        public final ByteBuffer[] getByteBuffers() {
            return new ByteBuffer[]{this.origBuffer};
        }

        public final void put(byte[] bytes) {
            this.origBuffer.put(bytes);
        }

        public final int capacity() {
            return this.origBuffer.capacity();
        }

        public final void clear() {
            this.origBuffer.clear();
        }

        public final void reset() {
            this.origBuffer.reset();
        }

        public final int remaining() {
            return this.origBuffer.remaining();
        }

        public final int position() {
            return this.origBuffer.position();
        }

        public final void mark() {
            this.origBuffer.mark();
        }

        public final int limit() {
            return this.origBuffer.limit();
        }

        public final boolean hasRemaining() {
            return this.origBuffer.hasRemaining();
        }

        public final void flip() {
            this.origBuffer.flip();
        }

        public final void put(byte b) {
            this.origBuffer.put(b);
        }

        public final void put(ByteBuffer buff) {
            this.origBuffer.put(buff);
        }

        public final ByteBuffer getByteBuffer() {
            return this.origBuffer;
        }

        public final void limit(int limit) {
            this.origBuffer.limit(limit);
        }

        public final void position(int pos) {
            this.origBuffer.position(pos);
        }
    }
}

