/**
 * Project Name:media-deploy<br>
 * File Name:SmsController.java<br>
 * Package Name:cn.com.duiba.tuia.media.web.controller<br>
 * Date:2016年9月26日下午3:21:31<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.web.controller;

import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.model.req.ReqSendSMS;
import cn.com.duiba.tuia.media.model.req.ReqVerifySMS;
import cn.com.duiba.tuia.media.service.SmsService;

/**
 * ClassName: SmsController <br/>
 * Function: 短信. <br/>
 * date: 2016年9月26日 下午3:21:31 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
//@Controller
//@RequestMapping("/sms")
//@Api("短信相关api")
public class SmsController extends BaseController {

    @Autowired
    private SmsService smsService;
    
    /**
     * 
     * send:(发送手机短信验证码). <br/>
     *
     * @author ZFZ
     * @param req
     * @param result
     * @return
     * @since JDK 1.6
     */
    @ResponseBody
    @ApiOperation(value = "发送手机短信验证码", httpMethod = "POST", notes = "发送手机短信验证码接口")
    @RequestMapping(value = "/send", method = RequestMethod.POST)
    public Result<Boolean> send (@Valid @RequestBody ReqSendSMS req, BindingResult result) {
        try {
            checkParam(result);
            return successResult(smsService.send(req));
        } catch (Exception e) {
            logger.error("SmsController.send error!");
            return failResult(e);
        }
    }

    /**
     * 
     * verify:(发送手机短信验证码). <br/>
     *
     * @author ZFZ
     * @param req
     * @param result
     * @return
     * @since JDK 1.6
     */
    @ResponseBody
    @ApiOperation(value = "发送手机短信验证码", httpMethod = "POST", notes = "发送手机短信验证码接口")
    @RequestMapping(value = "/verify", method = RequestMethod.POST)
    public Result<Boolean> verify(@Valid @ModelAttribute ReqVerifySMS req, BindingResult result) {
        try {
            checkParam(result);

            return successResult(smsService.verify(req.getType(), req.getPhone(), req.getCode()));
        } catch (Exception e) {
            logger.error("SmsController.send error!");
            return failResult(e);
        }
    }
}
