/**
 * Project Name:media-deploy<br>
 * File Name:TestController.java<br>
 * Package Name:cn.com.duiba.tuia.media.web.controller<br>
 * Date:2016年12月28日下午4:48:21<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.service.impl.MediaCacheService;
import cn.com.duiba.tuia.media.service.impl.SlotCacheService;

/**
 * ClassName: TestController <br/>
 * Function: 获取缓存. <br/>
 * date: 2016年12月28日 下午4:48:21 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@Controller
@RequestMapping("/test")
@Api("获取缓存相关api")
public class TestController extends BaseController {

    @Autowired
    private MediaCacheService mediaCacheService;
    
    @Autowired
    private SlotCacheService slotCacheService;

    @ResponseBody
    @ApiOperation(value = "获取媒体名称缓存", httpMethod = "GET", notes = "获取媒体名称缓存接口")
    @RequestMapping(value = "/getAppNameById", method = RequestMethod.GET)
    @ApiImplicitParam(name = "appId", value = "媒体应用ID", required = true, dataType = "Long", paramType = "query")
    public Result<String> getAppNameById(Long appId) {
        try {
            // 参数校验
            return successResult(mediaCacheService.getAppNameByIdKey(appId));
        } catch (Exception e) {
            logger.error("TestController.getAppNameById error!,the appId=[{}]", appId);
            return failResult(e);
        }
    }
    
    @ResponseBody
    @ApiOperation(value = "获取广告名称缓存", httpMethod = "GET", notes = "获取广告名称缓存接口")
    @RequestMapping(value = "/getSlotNameById", method = RequestMethod.GET)
    @ApiImplicitParam(name = "slotId", value = "广告ID", required = true, dataType = "Long", paramType = "query")
    public Result<String> getSlotNameById(Long slotId) {
        try {
            return successResult(slotCacheService.getSlotNameCacheById(slotId));
        } catch (Exception e) {
            logger.error("TestController.getSlotNameById error!,the slotId=[{}]", slotId);
            return failResult(e);
        }
    }
}
