/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.core.api.dto.TagLevel;
import cn.com.duiba.tuia.core.api.remoteservice.RemoteTagBackendService;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.web.controller.BaseController;
import cn.com.duiba.wolf.dubbo.DubboResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tag"})
@Api(value="\u6807\u7b7e\u76f8\u5173api")
public class TagController
extends BaseController {
    private static final int ACTIVITY_TAG_LIBRARY = 1;
    private static final int ADVERT_TAG_LIBRARY = 2;
    private static final int BANNED_TAG_LIBRARY = 3;
    @Autowired
    private RemoteTagBackendService remoteTagBackendService;

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u6807\u7b7e\u5e93", httpMethod="GET", notes="\u67e5\u8be2\u6807\u7b7e\u5e93\u63a5\u53e3")
    @RequestMapping(value={"getTagLibrary"}, method={RequestMethod.GET})
    public Result<List<TagLevel>> getTagLibrary(@RequestParam Integer type, HttpServletResponse response) {
        try {
            if (type == null) {
                throw new TuiaMediaException(ErrorCode.E0001005);
            }
            DubboResult dubboResult = new DubboResult();
            if (2 == type) {
                dubboResult = this.remoteTagBackendService.getAdvertTagLibrary();
            } else if (1 == type) {
                dubboResult = this.remoteTagBackendService.getActivityTagLibrary();
            } else if (3 == type) {
                dubboResult = this.remoteTagBackendService.getBannedTagLibrary();
            } else {
                throw new TuiaMediaException(ErrorCode.E0001005);
            }
            this.doTuiaCoreException(dubboResult, "remoteTagBackendService.getAdvertTagLibrary");
            return this.successResult(dubboResult.getResult());
        }
        catch (Exception e) {
            this.logger.error("BaseController.getTagLibrary error!");
            return this.failResult(e);
        }
    }
}

