/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum RewardTaskType {
    READING_NEWS(1L, "\u9605\u8bfb\u6587\u7ae0"),
    SIGN_IN(2L, "\u767b\u5f55\u5956\u52b1");

    private Long taskId;
    private String taskDescription;
    private static final Map<Long, RewardTaskType> CACHE;

    private RewardTaskType(Long taskId, String taskDescription) {
        this.taskId = taskId;
        this.taskDescription = taskDescription;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public static RewardTaskType getByTaskId(Long taskId) {
        RewardTaskType rewardTaskType = CACHE.get(taskId);
        if (rewardTaskType != null) {
            return rewardTaskType;
        }
        return null;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(RewardTaskType.values()), RewardTaskType::getTaskId);
    }
}

