package cn.com.duiba.tuia.news.center.dto;

import java.io.Serializable;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: UserDto.java , v 0.1 2017/12/28 下午2:40 ZhouFeng Exp $
 */
public class UserDto implements Serializable {

    private static final long serialVersionUID = -1781348640181205055L;
    /**
     * 用户ID
     */
    private Long userId;

    private String token;

    /**
     * 是否为新用户
     */
    private Boolean newUser;

    /**
     * 新用户的奖励，单位：分
     */
    private Long reward;

    private UserDto(Builder builder) {
        setUserId(builder.userId);
        setToken(builder.token);
        setNewUser(builder.newUser);
        setReward(builder.reward);
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Boolean getNewUser() {
        return newUser;
    }

    public void setNewUser(Boolean newUser) {
        this.newUser = newUser;
    }

    public Long getReward() {
        return reward;
    }

    public void setReward(Long reward) {
        this.reward = reward;
    }

    public static final class Builder {
        private Long userId;
        private String token;
        private Boolean newUser;
        private Long reward;

        public Builder() {
            //builder
        }

        public Builder userId(Long val) {
            userId = val;
            return this;
        }

        public Builder token(String val) {
            token = val;
            return this;
        }

        public Builder newUser(Boolean val) {
            newUser = val;
            return this;
        }

        public Builder reward(Long val) {
            reward = val;
            return this;
        }

        public UserDto build() {
            return new UserDto(this);
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < 1024; i++) {
            String s = String.valueOf(i);
            if (s.length() == 1)
                s = "000" + s;
            if (s.length() == 2)
                s = "00" + s;
            if (s.length() == 3)
                s = "0" + s;
            System.out.println("ALTER TABLE tb_user_"+s+" ADD COLUMN head_image VARCHAR(512) null DEFAULT '' COMMENT '用户头像';");
        }
    }
}
