package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.req.SignInResultDto;
import cn.com.duiba.tuia.news.center.dto.rsp.BeInvitedTaskCompleteDto;
import cn.com.duiba.tuia.news.center.dto.rsp.ReadingTaskCompleteDto;
import cn.com.duiba.tuia.news.center.dto.rsp.WatchingTaskCompleteDto;

/**
 * @author ElinZhou
 * @version $Id: RemoteRewardTaskService.java , v 0.1 2018/1/3 上午11:41 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteRewardTaskService {
    /**
     * 完成阅读
     * @param userId 用户id
     * @param newsId 新闻id
     * @return 完成阅读任务返回
     */
    ReadingTaskCompleteDto readingComplete(Long userId, String newsId) throws BizException;

    /**
     * 完成观看
     *
     * @param userId 用户id
     * @param videoId 视频id
     * @return 完成观看视频任务返回
     */
    WatchingTaskCompleteDto watchingComplete(Long userId, String videoId) throws BizException;


    /**
     * 判断该用户是否完成今日阅读任务(今日阅读奖励全部获得)
     * @param userId 用户id
     * @return 完成情况 true-全部完成 false-未完成
     */
    Boolean isTodayReadingTaskDone(Long userId);

    /**
     * 该篇新闻是否有阅读奖励
     * @param userId 用户id
     * @param newsId 新闻id
     * @return true-有 false-无
     */
    Boolean hasReadingReward(Long userId,String newsId);

    /**
     * 该视频是否有观看奖励
     * 
     * @param userId 用户id
     * @param videoId 视频id
     * @return true-有 false-无
     */
    Boolean hasWatchingReward(Long userId, String videoId);

    /**
     * 签到
     * @param userId 用户id
     * @return 签到结果
     */
    SignInResultDto signIn(Long userId) throws BizException;


    BeInvitedTaskCompleteDto beInvited(Long userId, String inviteCode) throws BizException;



}
