/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import cn.com.duiba.tuia.news.center.enums.LoginRewardSignInReward;
import cn.com.duiba.tuia.news.center.enums.RandomReward;
import cn.com.duiba.tuia.news.center.enums.RewardUnit;
import cn.com.duiba.tuia.news.center.enums.SignInReward;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

public enum NewUserSignInReward implements SignInReward
{
    DAY_ONE(1, 0L, RewardUnit.CHANGE),
    DAY_TWO(2, 2L, RewardUnit.CHANGE),
    DAY_THREE(3, 1L, RewardUnit.CHANGE),
    DAY_FOUR(4, 1L, RewardUnit.CHANGE),
    DAY_FIVE(5, 2L, RewardUnit.CHANGE),
    DAY_SIX(6, 1L, RewardUnit.CHANGE),
    DAY_SEVEN(7, 3L, RewardUnit.CHANGE);

    private Integer day;
    private Long rewardFee;
    private RewardUnit rewardUnit;
    private static final Map<Integer, NewUserSignInReward> CACHE;

    private NewUserSignInReward(Integer day, Long rewardFee, RewardUnit rewardUnit) {
        this.day = day;
        this.rewardFee = rewardFee;
        this.rewardUnit = rewardUnit;
    }

    @Override
    public Long getRewardFee() {
        switch (this.rewardFee.intValue()) {
            case 0: {
                Integer reward0 = new Random().nextInt(20) + 11;
                return reward0.longValue();
            }
            case 1: {
                Integer reward1 = new Random().nextInt(20) + 1;
                return reward1.longValue();
            }
            case 2: {
                RandomReward loginRewardSignInReward = RandomReward.getReward(LoginRewardSignInReward.values());
                return loginRewardSignInReward.getRewardFee();
            }
            case 3: {
                Integer reward3 = new Random().nextInt(30) + 20;
                return reward3.longValue();
            }
        }
        return 0L;
    }

    @Override
    public Integer getDay() {
        return this.day;
    }

    @Override
    public RewardUnit getRewardUnit() {
        return this.rewardUnit;
    }

    public static NewUserSignInReward getByDay(Integer day) {
        return Optional.ofNullable(CACHE.get(day)).orElseThrow(() -> new RuntimeException("\u7b7e\u5230\u5f02\u5e38"));
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(NewUserSignInReward.values()), NewUserSignInReward::getDay);
    }
}

