package cn.com.duiba.tuia.news.center.enums;

/**
 * @author ElinZhou
 * @version $Id: ErrorCode.java , v 0.1 2017/12/28 下午3:24 ElinZhou Exp $
 */
public enum ErrorCode {

                       ACCOUNT_EXCEPTION("E0300001", "账号异常"),

                       NOT_SUPPORT_LOGIN_TYPE("E0300001", "不支持的登录类型"),

                       INVALID_TOKEN("E0300002", "无效token"),

                       ORDER_NOT_EXIST("E0300003", "流水不存在"),

                       LACK_OF_CHANGE_BALANCE("E0300004", "零钱余额不足"),

                       LACK_OF_COIN_BALANCE("E0300005", "金币余额不足"),

                       REWARD_TASK_NOT_EXIST("E0300006", "奖励任务不存在"),

                       OVER_TASK_MAX_LIMIT_TIMES("E0300007", "超过任务可领取次数上限"),

                       ARTICLE_ALREADY_READED("E0300008", "该任务对象已领取"),

                       USER_NOT_EXIST("E0300009", "用户不存在"),

                       EXCHANGE_RATE_DUPLICATE("E0300010", "汇率日期重复"),;

    private String code;

    private String description;

    ErrorCode(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

}
