package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.UserWithdrawDetailDto;
import cn.com.duiba.tuia.news.center.dto.WithdrawApplyDto;
import cn.com.duiba.tuia.news.center.dto.WithdrawOrderDto;
import cn.com.duiba.tuia.news.center.enums.ApplyStatus;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author ElinZhou
 * @version $Id: RemoteWithdrawService.java , v 0.1 2018/1/3 上午11:13 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteWithdrawService {


    /**
     * 提现申请
     *
     * @param withdrawApplyDto 申请参数
     * @return 提现流水号
     * @throws BizException
     */
    Long apply(WithdrawApplyDto withdrawApplyDto) throws BizException;


    /**
     * 提现审核
     *
     * @param serialNumber 提现流水号
     * @param status       目标状态
     * @return
     * @throws BizException
     */
    boolean check(Long serialNumber, ApplyStatus status) throws BizException;


    /**
     * 通过零钱流水号查询订单
     *
     * @param changeSerialNumbers
     * @return map中key为零钱流水号，value为订单详情；不包括不存在的记录
     */
    Map<Long, WithdrawOrderDto> queryByChangeSerialNumber(List<Long> changeSerialNumbers);


    /**
     * 通过状态时间查询订单
     *
     * @param status   提现状态（null 表示不限）
     * @param start    查询开始时间
     * @param end      查询结束时间
     * @param page     页码
     * @param pageSize 每页数量
     * @return
     */
    List<WithdrawOrderDto> queryByStatusAndTime(ApplyStatus status, Date start, Date end, int page, int pageSize);


    /**
     * 查询提现数量
     *
     * @param status 提现状态（null 表示不限）
     * @param start    查询开始时间
     * @param end      查询结束时间
     * @return 记录数量
     * @throws BizException
     */
    Long queryCountByStatus(ApplyStatus status, Date start, Date end);

    /**
     * 用户提现详情
     *
     * @param userId
     * @return
     */
    UserWithdrawDetailDto queryUserWithdrawDetail(Long userId) throws BizException;
}
