package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.AddActivityDto;
import cn.com.duiba.tuia.news.center.dto.AgentAccountDto;
import cn.com.duiba.tuia.news.center.dto.NewsActivityDto;
import cn.com.duiba.tuia.news.center.dto.NewsActivityQueryDto;
import cn.com.duiba.tuia.news.center.dto.Response.NewsActivityResponse;
import cn.com.duiba.tuia.news.center.dto.UpdateActivityDto;
import cn.com.duiba.tuia.news.center.dto.req.MediaAccountStatusDto;
import cn.com.duiba.tuia.news.center.dto.req.MediaAgentAccountQueryDto;
import cn.com.duiba.tuia.news.center.dto.req.PageQueryResultDto;
import cn.com.duiba.tuia.news.center.enums.ActivityValidStatus;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAgentAccountService {

    /**
     * 根据Id查询代理
     * @param id
     * @return
     */
    AgentAccountDto selectById(Long id);


    /**
     * 分页查询代理账号
     * @param mediaAgentAccountQueryDto
     * @return
     */
    PageQueryResultDto<AgentAccountDto> selectList(MediaAgentAccountQueryDto mediaAgentAccountQueryDto);

    /**
     * 批量更新代理状态
     * @return
     */
    Boolean batchUpdateAgentStatus(MediaAccountStatusDto mediaAccountStatusDto);

    /**
     * 新增、更新代理信息
     * @param agentAccountDto
     * @return
     */
    Boolean save(AgentAccountDto agentAccountDto);

    /**
     * 更新代理状态
     * @param mediaAccountStatusDto
     * @return
     */
    Boolean updateAgentStatus(MediaAccountStatusDto mediaAccountStatusDto);
}
