package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.Response.TagLibraryResponse;
import cn.com.duiba.tuia.news.center.dto.TagLibraryDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteNewTagService {

    /**
     * 查询所有标签
     */
    List<TagLibraryDto> selectAll();


    /**
     * 根据内容与标签等级模糊查询标签内容 已经格式好，直接返回给前端
     * @param content 标签内容  模糊查询
     * @param tagLevel 标签等级
     * @return 标签列表 格式  List<A->B>
     */
    List<TagLibraryResponse> selectByContentAndTagLevel(String content,Integer tagLevel);
}
