/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import cn.com.duiba.tuia.news.center.enums.LoginReward;
import cn.com.duiba.tuia.news.center.enums.RandomReward;
import cn.com.duiba.tuia.news.center.enums.RewardUnit;
import cn.com.duiba.tuia.news.center.enums.SignInReward;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

public enum NewUserSignInReward implements SignInReward
{
    DAY_ONE(1, 12L, RewardUnit.CHANGE),
    DAY_TWO(2, 15L, RewardUnit.COIN),
    DAY_THREE(3, -1L, RewardUnit.CHANGE),
    DAY_FOUR(4, 25L, RewardUnit.COIN),
    DAY_FIVE(5, -1L, RewardUnit.CHANGE),
    DAY_SIX(6, 35L, RewardUnit.COIN),
    DAY_SEVEN(7, -1L, RewardUnit.CHANGE);

    private Integer day;
    private Long rewardFee;
    private RewardUnit rewardUnit;
    private static final Map<Integer, NewUserSignInReward> CACHE;

    private NewUserSignInReward(Integer day, Long rewardFee, RewardUnit rewardUnit) {
        this.day = day;
        this.rewardFee = rewardFee;
        this.rewardUnit = rewardUnit;
    }

    @Override
    public Long getRewardFee() {
        if (this.rewardFee.equals(-1L)) {
            RandomReward loginReward = RandomReward.getReward(LoginReward.values());
            return loginReward.getRewardFee();
        }
        return this.rewardFee;
    }

    @Override
    public Integer getDay() {
        return this.day;
    }

    @Override
    public RewardUnit getRewardUnit() {
        return this.rewardUnit;
    }

    public static NewUserSignInReward getByDay(Integer day) {
        return Optional.ofNullable(CACHE.get(day)).orElseThrow(() -> new RuntimeException("\u7edb\u60e7\u57cc\u5bee\u509a\u7236"));
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(NewUserSignInReward.values()), NewUserSignInReward::getDay);
    }
}

