/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import cn.com.duiba.tuia.news.center.enums.RewardUnit;
import cn.com.duiba.tuia.news.center.enums.SignInReward;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

public enum OldUserSignInReward implements SignInReward
{
    DAY_ONE(1, 10L, RewardUnit.COIN),
    DAY_TWO(2, 15L, RewardUnit.COIN),
    DAY_THREE(3, 20L, RewardUnit.COIN),
    DAY_FOUR(4, 25L, RewardUnit.COIN),
    DAY_FIVE(5, 30L, RewardUnit.COIN),
    DAY_SIX(6, 35L, RewardUnit.COIN),
    DAY_SEVEN(7, 40L, RewardUnit.COIN);

    private Integer day;
    private Long rewardFee;
    private RewardUnit rewardUnit;
    private static final Map<Integer, OldUserSignInReward> CACHE;

    private OldUserSignInReward(Integer day, Long rewardFee, RewardUnit rewardUnit) {
        this.day = day;
        this.rewardFee = rewardFee;
        this.rewardUnit = rewardUnit;
    }

    @Override
    public Integer getDay() {
        return this.day;
    }

    @Override
    public Long getRewardFee() {
        return this.rewardFee;
    }

    @Override
    public RewardUnit getRewardUnit() {
        return this.rewardUnit;
    }

    public static OldUserSignInReward getByDay(Integer day) {
        return Optional.ofNullable(CACHE.get(day)).orElseThrow(() -> new RuntimeException("\u7edb\u60e7\u57cc\u5bee\u509a\u7236"));
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(OldUserSignInReward.values()), OldUserSignInReward::getDay);
    }
}

