/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum RewardTaskType {
    READING_NEWS(1L, "\u95c3\u5470\ue1f0\u93c2\u56e9\u73f7"),
    SIGN_IN(2L, "\u59e3\u5fd4\u68e9\u9427\u8bf2\u7d8d"),
    COMPENSATE(3L, "\u9422\u3126\u57db\u741b\u30e5\u4f29"),
    WATCH_VIDEO(4L, "\u7459\u509c\u6e45\u7459\u55db\ue576"),
    INVITE_READ(5L, "\u6fc2\u85c9\u5f38\u95c3\u5470\ue1f0"),
    BIND_INVITE_CODE(6L, "\u7f01\u621d\u757e\u95ad\ufffd\u7487\u98ce\u721c"),
    ACCOUNT_BIND_CODE(7L, "\u7039\u5c7d\u677d\u74a7\u52ec\u67a1");

    private Long taskId;
    private String taskDescription;
    private static final Map<Long, RewardTaskType> CACHE;

    private RewardTaskType(Long taskId, String taskDescription) {
        this.taskId = taskId;
        this.taskDescription = taskDescription;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public static RewardTaskType getByTaskId(Long taskId) {
        RewardTaskType rewardTaskType = CACHE.get(taskId);
        if (rewardTaskType != null) {
            return rewardTaskType;
        }
        return null;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(RewardTaskType.values()), RewardTaskType::getTaskId);
    }
}

