package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.RewardTaskCompleteDto;
import cn.com.duiba.tuia.news.center.dto.RewardTaskDto;

import java.util.List;
import java.util.Map;

/**
 * @author ElinZhou
 * @version $Id: RemoteRewardTaskService.java , v 0.1 2018/1/3 上午11:41 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteRewardTaskService {

    /**
     * 完成任务
     *
     * @param userId 用户id
     * @param item   兑换项id，例如文章id
     * @return
     */
    RewardTaskCompleteDto complete(Long userId, Long taskId, Long item) throws BizException;

    /**
     * 通过任务id查询
     *
     * @param taskId
     * @return
     */
    RewardTaskDto queryTaskById(Long taskId);

    /**
     * 查询任务ids
     *
     * @param taskIds
     * @return
     */
    Map<Long, RewardTaskDto> queryTaskByIds(List<Long> taskIds);

}
