package cn.com.duiba.tuia.news.center.enums;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: PushType.java , v 0.1 2018/5/24 下午6:27 ZhouFeng Exp $
 */
public enum LuckPacketType {

    /**
     *红包过期
     */
    PAST(-2),

    /**
     * 今天领取红包已经达到上限
     */
    OPENTOP(-1),

    /**
     * 红包应被领完
     */
    CLEAR(0),

    /**
     * 可以领取
     */
    CANOPEN(1),

    /**
     * 已经领取过
     */
    ALREADY(2)
    ;

    private Integer code;


    LuckPacketType(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }
}
