package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.WithdrawTicketDto;

import java.util.List;

/**
 * Created by xiaotian on 2018/4/17.
 */
@AdvancedFeignClient
public interface RemoteWithdrawTicketService {

    /**
     * 获取特权券
     * @param userId
     * @param source
     * @param fee
     * @return
     */
    boolean getTicket(Long userId,Integer source,Long fee) throws BizException;

    /**
     * 查询特权券
     * @param userId
     * @param source
     * @param fee
     * @return
     */
    Integer getTicketCount(Long userId,Integer source,Long fee,Integer status);

    /**
     * 获取可用的提现券（特权券+日常券）
     * @param userId
     * @return
     */
    List<WithdrawTicketDto> getPacketTicket(Long userId);

    /**
     * 判断是否领取过该类型的
     * @param userId
     * @param source
     * @param fee
     * @return
     */
    Boolean hasgotTicket(Long userId,Integer source,Long fee);

}
