package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.AppVersionDto;
import cn.com.duiba.tuia.news.center.dto.ConfigDto;
import cn.com.duiba.tuia.news.center.enums.AppType;

import java.util.List;
import java.util.Map;

/**
 * @author ElinZhou
 * @version $Id: RemoteAppVersionService.java , v 0.1 2018/1/4 下午8:09 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteAppVersionService {


    /**
     * 查询最新的版本
     *
     * @param appType
     * @return
     */
    AppVersionDto queryTheLatestVersion(AppType appType);

    /**
     * 获取权限版本
     * @return
     */
    List<String> getVersionList();

    /**
     * 获取全局配置信息
     * @return
     */
    Map<String,Object> getConfig();

    /**
     * 更新配置文件接口
     */
    Boolean updateConfig(ConfigDto configDto);

}
