package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

public enum RewardTaskType implements CoinTradeCode {

                            READING_NEWS(1L, "阅读文章"),

                            SIGN_IN(2L, "每日登录"),

                            COMPENSATE(3L, "用户补偿"),

                            WATCH_VIDEO(4L, "观看视频"),

                            INVITE_READ(5L, "好友阅读"),

                            BIND_INVITE_CODE(6L, "绑定邀请码"),

                            ACCOUNT_BIND_CODE(7L,"完善资料"),

                            PICK_PACKET(8L,"收取红包"),

                            SHARE_INVITE(9L,"分享邀请链接"),

                            HAOWAN_GAME(10L,"好玩小游戏"),

                            STEAL_PACKET(11L,"偷取红包"),

                            POINT_PACKET(12L,"疯狂抽奖")

    ;

    private Long   taskId;
    private String taskDescription;

    private static final Map<Long, RewardTaskType> CACHE = Maps.uniqueIndex(Arrays.asList(RewardTaskType.values()),
            RewardTaskType::getTaskId);

    RewardTaskType(Long taskId, String taskDescription) {
        this.taskId = taskId;
        this.taskDescription = taskDescription;
    }

    @Override
    public Long getTaskId() {
        return taskId;
    }

    @Override
    public String getTaskDescription() {
        return taskDescription;
    }

    public static RewardTaskType getByTaskId(Long taskId) {
        RewardTaskType rewardTaskType = CACHE.get(taskId);
        if (rewardTaskType != null) {
            return rewardTaskType;
        }
        return null;
    }
}
