package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.DomainConfigDto;
import cn.com.duiba.tuia.news.center.dto.req.PageQueryResultDto;
import cn.com.duiba.tuia.news.center.enums.DomainPageEnum;

import java.util.List;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RemoteDomainConfigService.java , v 0.1 2018/5/15 下午6:33 ZhouFeng Exp $
 */
@AdvancedFeignClient
public interface RemoteDomainConfigService {

    /**
     * 查询当前可用域名
     *
     * @param domainPage 页面
     * @param page       页码
     * @param pageSize   每页数量
     * @return
     */
    PageQueryResultDto<DomainConfigDto> listAvaliable(DomainPageEnum domainPage, Integer page, Integer pageSize);

    /**
     * 添加域名
     *
     * @param domainPage 页面
     * @param url        链接，无http://
     * @return
     */
    Boolean addDomain(DomainPageEnum domainPage, String url);

    /**
     * 删除域名
     *
     * @param id
     * @return
     */
    Boolean deleteDomain(Long id);

    /**
     * 查询当前使用中的域名
     *
     * @param domainPage 页面
     * @return
     * @throws BizException
     */
    DomainConfigDto queryUsingDomain(DomainPageEnum domainPage) throws BizException;

    /**
     * 查询所有使用中的域名
     *
     * @return
     */
    List<DomainConfigDto> listUsingDomain();

    /**
     * 域名切换
     *
     * @param domainPage 页面
     * @return
     * @throws BizException
     */
    Boolean domainSwitch(DomainPageEnum domainPage) throws BizException;

}
