package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.SignInfoDto;
import cn.com.duiba.tuia.news.center.dto.TodaySignInDto;

@AdvancedFeignClient
public interface RemoteUserSignInService {
    /**
     * 获取登录签到完成轮数
     * @param userId 用户 id
     * @return 获取完整签到轮数
     */
    Integer getRounds(Long userId);

    /**
     * 获取连续签到天数
     * @param userId 用户 id
     * @return 连续签到天数
     */
    Integer getContinueDays(Long userId);

    /**
     * 判断该用户是否处于新用户签到周期
     * @param userId 用户 id
     * @return true-是 false-否
     */
    Boolean newUser(Long userId);

    /**
     * 判断今日是否已经签到过
     * @param userId
     * @return
     */
    TodaySignInDto todayIsSignIn(Long userId);

    /**
     * 查询今日签到信息
     *
     * @param userId
     * @return
     */
    SignInfoDto queryTodaySignInfo(Long userId);
}
