package cn.com.duiba.tuia.news.center.dto;

import java.io.Serializable;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: LoginDto.java , v 0.1 2017/12/28 下午2:37 ZhouFeng Exp $
 */
public class LoginDto<T extends LoginAuthDto> implements Serializable {

    private static final long serialVersionUID = 1890955652773620573L;
    /**
     * 身份验证参数
     */
    private T authDto;

    /**
     * 设备号
     */
    private String deviceId;

    /**
     * 电子串号
     */
    private String iemi;

    /**
     * 手机号
     */
    private String phoneNum;

    /**
     * 用户昵称
     */
    private String nickName;

    /**
     * 用户头像
     */
    private String headImage;

    /**
     * 登陆版本号
     */
    private String version;

    /**
     * 分辨率（宽）
     */
    private Integer resolutionWidth;

    /**
     * 分辨率（高）
     */
    private Integer resolutionHeight;

    /**
     * 设备型号
     */
    private String deviceModel;

    /**
     * 操作系统 Android,iOS
     */
    private String system;

    /**
     * 操作系统版本
     */
    private String osVersion;



    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public LoginDto(){}

    public  LoginDto(T authDto) {
        this.authDto = authDto;
    }


    public T getAuthDto() {
        return authDto;
    }

    public String getHeadImage() {
        return headImage;
    }

    public void setHeadImage(String headImage) {
        this.headImage = headImage;
    }

    public void setAuthDto(T authDto) {
        this.authDto = authDto;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getIemi() {
        return iemi;
    }

    public void setIemi(String iemi) {
        this.iemi = iemi;
    }

    public String getPhoneNum() {
        return phoneNum;
    }

    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Integer getResolutionWidth() {
        return resolutionWidth;
    }

    public void setResolutionWidth(Integer resolutionWidth) {
        this.resolutionWidth = resolutionWidth;
    }

    public Integer getResolutionHeight() {
        return resolutionHeight;
    }

    public void setResolutionHeight(Integer resolutionHeight) {
        this.resolutionHeight = resolutionHeight;
    }

    public String getDeviceModel() {
        return deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public String getOsVersion() {
        return osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getSystem() {
        return system;
    }

    public void setSystem(String system) {
        this.system = system;
    }
}
