package cn.com.duiba.tuia.news.center.enums;

/**
 * 任务奖励单位
 *
 * @author ElinZhou
 * @version $Id: RewardUnit.java , v 0.1 2017/12/31 下午9:30 ElinZhou Exp $
 */
public enum RewardUnit {

                        /** 金币 */
                        COIN(1),

                        /** 现金 */
                        CHANGE(2),

    ;

    private Integer code;

    RewardUnit(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }

    public static RewardUnit of(Integer aCode) {
        if (aCode == null) {
            return null;
        }
        for (RewardUnit rewardUnit : values()) {
            if (rewardUnit.getCode().equals(aCode)) {
                return rewardUnit;
            }
        }
        return null;
    }

    public boolean same(Integer other) {
        if (other == null) {
            return false;
        }
        return code.equals(other);
    }
}
