package cn.com.duiba.tuia.news.center.remoteservice;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.*;
import cn.com.duiba.tuia.news.center.dto.req.PageQueryResultDto;
import cn.com.duiba.tuia.news.center.dto.req.UserActionStatisticDto;
import cn.com.duiba.tuia.news.center.dto.req.WithdrawQueryDto;
import cn.com.duiba.tuia.news.center.enums.ApplyStatus;

/**
 * @author ElinZhou
 * @version $Id: RemoteWithdrawService.java , v 0.1 2018/1/3 上午11:13 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteWithdrawService {


    /**
     * 提现申请
     *
     * @param withdrawApplyDto 申请参数
     * @return 提现流水号
     * @throws BizException
     */
    Long apply(WithdrawApplyDto withdrawApplyDto) throws BizException;



    /**
     * 提现申请（一元提现返回奖励）
     *
     * @param withdrawApplyDto 申请参数
     * @return 提现流水号
     * @throws BizException
     */
    ApplyWithdrawDto applyV2(WithdrawApplyDto withdrawApplyDto) throws BizException;

    /**
     * 提现申请（一元提现返回奖励）
     *
     * @param withdrawApplyDto 申请参数
     * @return 提现流水号
     * @throws BizException
     */
    ApplyWithdrawDto applyV3(WithdrawApplyDto withdrawApplyDto) throws BizException;


    /**
     * 提现审核(1.2.0版本发布后删除)
     *
     * @param serialNumber 提现流水号
     * @param status       目标状态
     * @return
     * @throws BizException
     */
    @Deprecated
    boolean check(Long serialNumber, ApplyStatus status) throws BizException;


    /**
     * 通过零钱流水号查询订单
     *
     * @param changeSerialNumbers
     * @return map中key为零钱流水号，value为订单详情；不包括不存在的记录
     */
    Map<Long, WithdrawOrderDto> queryByChangeSerialNumber(List<Long> changeSerialNumbers);


    /**
     * 通过状态时间查询订单(1.2.0版本发布后删除)
     *
     * @param status   提现状态（null 表示不限）
     * @param start    查询开始时间
     * @param end      查询结束时间
     * @param page     页码
     * @param pageSize 每页数量
     * @return
     */
    @Deprecated
    List<WithdrawOrderDto> queryByStatusAndTime(ApplyStatus status, Date start, Date end, int page, int pageSize);


    /**
     * 查询提现数量(1.2.0版本发布后删除)
     *
     * @param status 提现状态（null 表示不限）
     * @param start    查询开始时间
     * @param end      查询结束时间
     * @return 记录数量
     * @throws BizException
     */
    @Deprecated
    Long queryCountByStatus(ApplyStatus status, Date start, Date end);

    /**
     * 用户提现详情
     *
     * @param userId
     * @return
     */
    UserWithdrawDetailDto queryUserWithdrawDetail(Long userId) throws BizException;


    /**
     * 批量通过接口
     * 
     * @param serialNumbers 订单号列表
     * @return
     */
    Boolean batchPass(List<Long> serialNumbers);

    /**
     * 批量驳回
     * 
     * @param serialNumbers 订单号列表
     * @return
     */
    Boolean batchTurnDown(List<Long> serialNumbers,String turnDwonNote);

    /**
     * 批量拒绝
     * 
     * @param serialNumbers 订单号列表
     * @return
     */
    Boolean batchReject(List<Long> serialNumbers);

    /**
     * 通过
     * 
     * @param serialNumber 订单号
     * @return
     */
    Boolean pass(Long serialNumber);

    /**
     * 驳回
     * 
     * @param serialNumber 订单号
     * @return
     */
    Boolean turnDown(Long serialNumber,String turnDwonNote);

    /**
     * 拒绝
     * 
     * @param serialNumber 订单号
     * @return
     */
    Boolean reject(Long serialNumber);

    /**
     * 获取提现订单列表
     * 
     * @param queryDto 查询条件对象
     * @return 订单列表
     */
    List<WithdrawOrderDto> list(WithdrawQueryDto queryDto);

    /**
     * 分页查询提现订单列表
     * 
     * @param queryDto 查询对象
     * @return 订单列表
     */
    PageQueryResultDto<WithdrawOrderDto> pageQuery(WithdrawQueryDto queryDto);

    /**
     * 获取用户行为统计数据
     * 
     * @param userIds 用户 id 列表
     * @return 用户行为统计数据
     */
    List<UserActionStatisticDto> getUserActionStatistic(List<Long> userIds);


    /**
     * 分页查询提现成功订单列表
     *
     * @param queryDto 基础查询对象
     * @return 订单列表
     */
    PageQueryResultDto pageQuerySuccessOrder(BaseQueryDto queryDto);


    /**
     * 限时红包用户是否被命中
     *
     * @param userId 用户 id 列表
     * @return 用户行为统计数据
     */
    Boolean getLimitPacketCheat(Long userId);

    /**
     * 恢复
     *
     * @param serialNumber 订单号
     * @return
     */
    Boolean recover(Long serialNumber);
}
