package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.AccountBalanceDto;
import cn.com.duiba.tuia.news.center.dto.AccountDetailDto;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RemoteAccountService.java , v 0.1 2018/1/3 下午2:18 ZhouFeng Exp $
 */
@AdvancedFeignClient
public interface RemoteAccountService {

    /**
     * 查询金币和零钱余额
     *
     * @param userId
     * @return
     */
    AccountBalanceDto queryBalance(Long userId);


    /**
     * 查询账户详情
     *
     * @param userId
     * @return
     */
    AccountDetailDto queryDetail(Long userId);
}
