/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum RelationType {
    FRIEND(0, "\u597d\u53cb"),
    ENEMY(1, "\u4ec7\u654c"),
    STRANGER(2, "\u964c\u751f\u4eba"),
    ASSISTANT(3, "\u8da3\u95fb\u5c0f\u79d8\u4e66");

    private Integer code;
    private String description;
    private static final Map<Integer, RelationType> CACHE;

    private RelationType(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static RelationType getByCode(Integer taskId) {
        RelationType relationType = CACHE.get(taskId);
        if (relationType != null) {
            return relationType;
        }
        return FRIEND;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(RelationType.values()), RelationType::getCode);
    }
}

