package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import com.sun.org.apache.bcel.internal.generic.NEW;

import java.util.Arrays;
import java.util.Map;

/**
 * @author ElinZhou
 * @version $Id: DomainPageEnum.java , v 0.1 2018/5/15 下午3:59 ElinZhou Exp $
 */
public enum DomainPageEnum {

    INVITE_PAGE("邀请好友", 1),

    /**
     * 新落地页（新活动，具体未定）
     */
    NEW_PAGE("新活动",2),



    ;


    private String name;

    private Integer id;

    DomainPageEnum(String name, Integer id) {
        this.name = name;
        this.id = id;
    }


    private static final Map<Integer, DomainPageEnum> CACHE = Maps.uniqueIndex(Arrays.asList(DomainPageEnum
            .values()), DomainPageEnum::getId);

    public static DomainPageEnum of(Integer id) {
        return CACHE.get(id);
    }

    public String getName() {
        return name;
    }

    public Integer getId() {
        return id;
    }
}
