package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

public enum LandTaskType {

                            SIGN_IN1(1, "登陆"),

                            SIGN_IN2(2, "登录"),

                            READYING_THERE(3, "阅读三篇文章"),

                            NEXT_SIGN_IN(4, "次日登陆"),

                            INVITE_ONE(5, "邀请一位活跃好友"),

                            FIVE_SIGN_IN(6, "连续五天登陆"),

                            INVITE_TEN(7,"邀请十位活跃好友")

    ;

    private Integer   taskId;
    private String taskDescription;

    private static final Map<Integer, LandTaskType> CACHE = Maps.uniqueIndex(Arrays.asList(LandTaskType.values()),
            LandTaskType::getTaskId);

    LandTaskType(Integer taskId, String taskDescription) {
        this.taskId = taskId;
        this.taskDescription = taskDescription;
    }

    public Integer getTaskId() {
        return taskId;
    }

    public String getTaskDescription() {
        return taskDescription;
    }

    public static LandTaskType getByTaskId(Integer taskId) {
        LandTaskType rewardTaskType = CACHE.get(taskId);
        if (rewardTaskType != null) {
            return rewardTaskType;
        }
        return null;
    }
}
