package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.req.RiskCheckReq;
import cn.com.duiba.tuia.news.center.enums.OpenInstallSourceType;

/**
 * Created by xuefeng on 2018/11/21.
 */
@AdvancedFeignClient
public interface RemoteRiskService {

    /**
     * 端外阅读奖励风控检验
     *
     * @param req
     * @return true:风控通过 false:风控禁止
     */
    Boolean readCheck(RiskCheckReq req);

    /**
     * 记录金币奖励行为
     *
     * @param req
     */
    void recordShare(RiskCheckReq req);

    /**
     * 分享链接添加加密分享时间
     *
     * @param url 分享链接
     * @return
     */
    String buildShareUrlWithTime(String url);
}
