package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.*;
import cn.com.duiba.tuia.news.center.dto.req.BindingReq;
import cn.com.duiba.tuia.news.center.dto.req.NewUserGuideReq;
import cn.com.duiba.tuia.news.center.dto.req.UserActionQueryReq;
import cn.com.duiba.tuia.news.center.enums.UserLoginType;

import java.util.List;

/**
 * @author ElinZhou
 * @version $Id: RemoteUserService.java , v 0.1 2017/12/28 下午2:36 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteUserService {


    /**
     * 登录
     *
     * @param loginUser 登录用户信息
     * @param loginType 登录方式
     * @return
     */
    UserDto login(LoginDto loginUser, UserLoginType loginType) throws BizException;

    /**
     * 登录
     *
     * @param loginUser 登录用户信息
     * @param loginType 登录方式
     * @return
     */
    UserDto login110(LoginDto loginUser, UserLoginType loginType) throws BizException;

    /**
     * 登录
     *
     * @param loginUser 登录用户信息
     * @param loginType 登录方式
     * @return
     */
    UserDto login120(LoginDto loginUser, UserLoginType loginType) throws BizException;

    /**
     * 1.6.2 版本以后的登录方式
     */
    UserDto login162(LoginDto loginUser, UserLoginType loginType) throws BizException;

    /**
     * token 转换为userId
     *
     * @param token
     * @return userId
     * @throws BizException
     */
    Long tokenExchange(String token) throws BizException;

    /**
     * 获取邀请码
     * 
     * @param userId 用户 id
     * @return 邀请码
     */
    String getInviteCode(Long userId) throws BizException;

    /**
     * 根据用户 id 获取用户信息
     * @param userId 用户 id
     * @return 用户信息
     */
    UserInfoDto getUserInfo(Long userId);

    /**
     * 判断该用户Id的登陆方式
     * @param userId
     * @return
     */
    BindingDto acquireUserLogin(Long userId);

    /**
     * 绑定用户
     * @param userId
     * @param type
     * @param account
     * @return
     */
    RewardDto binding(Long userId, UserLoginType type , String  account, String verificationCode) throws BizException;

    /**
     * 绑定用户
     * @return
     */
    RewardDto bindingV2(BindingReq bindingReq) throws BizException;

    /**
     * 发送短信验证码
     * @param phoneNum
     * @return
     */
     boolean sendVerificationCode(String  phoneNum,String deviceId) throws BizException;

    /**
     * 查询用户活跃度
     * @param userId
     * @return
     */
    Integer getUserActive(Long userId) throws BizException;

    /**
     * 获取随机用户列表
     * @param count
     * @return
     */
    List<UserInfoDto> getRandomUserList(Integer count);

    /**
     * 获取用户行为
     */
    UserActionDto getUserAction(UserActionQueryReq req);

    /**
     * 插入用户行为
     */
    Boolean insertUserAction(UserActionDto userActionDto);

    /**
     * 是否还有新人引导阅读奖励
     */
    Boolean haveNewUserReadingGuide(NewUserGuideReq req);
}
