/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum OpenInstallSourceType {
    DOUBLE_SHARE(0),
    TUIA(1),
    LUCK_PACKET(3),
    POINT_POCKET(4),
    SIGN_IN_SHARE(5),
    HOT_ARTICLE(6),
    LIMIT_PACKET(7),
    ARTICLE_SHARE(8),
    WECHAT_HOT_ARTICLE(9);

    private static final Map<Integer, OpenInstallSourceType> CECHA;
    private Integer type;

    private OpenInstallSourceType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return this.type;
    }

    public static Boolean contain(Integer type) {
        for (OpenInstallSourceType openInstallSourceType : OpenInstallSourceType.values()) {
            if (!openInstallSourceType.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public static OpenInstallSourceType getByType(Integer type) {
        OpenInstallSourceType openInstallSourceType = CECHA.get(type);
        if (openInstallSourceType != null) {
            return openInstallSourceType;
        }
        return null;
    }

    static {
        CECHA = Maps.uniqueIndex(Arrays.asList(OpenInstallSourceType.values()), OpenInstallSourceType::getType);
    }
}

