package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

public enum RewardTaskType implements CoinTradeCode {

                            READING_NEWS(1L, "阅读文章"),

                            SIGN_IN(2L, "签到奖励"),

                            COMPENSATE(3L, "用户补偿"),

                            WATCH_VIDEO(4L, "观看视频"),

                            INVITE_READ(5L, "好友阅读"),

                            BIND_INVITE_CODE(6L, "绑定邀请码"),

                            ACCOUNT_BIND_CODE(7L,"完善资料"),

                            PICK_PACKET(8L,"收取红包"),

                            SHARE_INVITE(9L,"分享邀请链接"),

                            HAOWAN_GAME(10L,"好玩小游戏"),

                            STEAL_PACKET(11L,"偷取红包"),

                            POINT_PACKET(12L,"疯狂抽奖"),

                            LUCK_PACKET_SHARE(13L,"群红包分享"),

                            SIGN_IN_SHARE(14L,"签到分享奖励"),

                            FRIEND_OPEN_SIGN_IN_SHARE(15L,"签到好友阅读奖励"),

                            FRIEND_OPEN_HOT_ARTICLE_SHARE(16L,"好友打开热文分享"),

                            ACTIVITY_SET_OPEN(17L,"用户打开合集"),

                            ARTICLE_SHARE_FIRST(18L,"首次正文分享奖励"),

                            ARTICLE_SHARE_READING(19L,"正文分享阅读奖励"),

                            TIME_COIN(20L,"时段奖励"),

                            OBJECT_REWARD(21L,"参与活动"),

                            RISK_CANCEL(22L,"风控取消"),

                            MISSION_162(31L,"任务奖励"),
                            MISSION_SHARE(32L,"任务:分享奖励"),
                            MISSION_PLANT(33L,"任务:种植奖励"),

                            LOGIN_REWARD_PLANT(41L,"新人种植奖励"),


    ;

    private Long   taskId;
    private String taskDescription;

    private static final Map<Long, RewardTaskType> CACHE = Maps.uniqueIndex(Arrays.asList(RewardTaskType.values()),
            RewardTaskType::getTaskId);

    RewardTaskType(Long taskId, String taskDescription) {
        this.taskId = taskId;
        this.taskDescription = taskDescription;
    }

    @Override
    public Long getTaskId() {
        return taskId;
    }

    @Override
    public String getTaskDescription() {
        return taskDescription;
    }

    public static RewardTaskType getByTaskId(Long taskId) {
        RewardTaskType rewardTaskType = CACHE.get(taskId);
        if (rewardTaskType != null) {
            return rewardTaskType;
        }
        return null;
    }
}
