package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.req.UserMessagePush;
import cn.com.duiba.tuia.news.center.dto.rsp.MessageCenterSystemDto;
import cn.com.duiba.tuia.news.center.dto.rsp.MessageCenterUserDto;

import java.util.List;


/**
 * 消息中心的messageCenter
 * @author lichao 2018/11/27
 */
@AdvancedFeignClient
public interface RemoteMessageCenterService {

    /**
     * 查询系统消息
     * @return
     */
    List<MessageCenterSystemDto> systemList();


    /**
     * 查询用户通知
     * @param userId
     * @return
     */
    List<MessageCenterUserDto> userList(Long userId);

    /**
     * 给用户发送通知
     * @param userMessagePush
     * @return
     */
    boolean addUserMessage(UserMessagePush userMessagePush);


    /**
     * 后台添加、更新系统公告内容
     */
    boolean saveForBk(MessageCenterSystemDto systemDto);


    /**
     * 查看系统公告详情
     */
    MessageCenterSystemDto selectById(Long id);


}
