package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.Response.WechatServiceDto;
import cn.com.duiba.tuia.news.center.dto.Response.WechatUrlConfig;
import cn.com.duiba.tuia.news.center.dto.Response.WechatUrlDto;
import cn.com.duiba.tuia.news.center.dto.Response.WechatUrlServiceConfig;
import cn.com.duiba.tuia.news.center.dto.req.PageQueryResultDto;
import cn.com.duiba.tuia.news.center.dto.req.WechatServiceReq;
import cn.com.duiba.tuia.news.center.dto.req.WechatUrlAddDto;

import java.util.List;

/**
 * Created by xiaotian on 2018/7/12.
 */
@AdvancedFeignClient
public interface RemoteWechatUrlService {

    /**
     * 根据版本号获取当前在用的微信服务号
     *
     * @param version 版本号 0：老  1：新
     * @return
     */
    WechatServiceDto getPresentService(Integer version);

    /**
     * 获取当前在用的微信服务号集合
     *
     * @return
     */
    List<WechatServiceDto> getPresentServiceList();


    /**
     * 根据服务号Id获取服务号信息
     *
     * @param serviceId
     * @return
     */
    WechatServiceDto getServiceById(Long serviceId);

    /**
     * 分页获取微信服务号
     *
     * @param version  版本号 0:老 1：新
     * @param pageNo   页号
     * @param pageSize 页量
     * @return
     */
    PageQueryResultDto<WechatServiceDto> getServicePageList(Integer version, Integer pageNo, Integer pageSize);

    /**
     * 分页获取微信服务号，支持是否异常，域名，id搜索
     *
     * @return
     */
    List<WechatServiceDto> getServicePageList2(WechatServiceReq req);

    /**
     * 根据服务号Id和url类型获取列表
     *
     * @param serviceId 服务号Id
     * @param type      1：后端 2：Jssdk
     * @return
     */
    PageQueryResultDto<WechatUrlDto> getUrlPageList(Long serviceId, Integer type, Integer pageNo, Integer pageSize);

    /**
     * 添加服务号
     *
     * @param version   版本号 0:老 1：新
     * @param serviceId
     * @param name
     * @param appid
     * @param appsecret
     * @return
     */
    boolean addService(Integer version, Long serviceId, String name, String appid, String appsecret);


    /**
     * 删除服务号配置，软删,-1表示删除
     *
     * @param version
     * @param serviceId
     * @return
     */
    boolean deleteService(Integer version, Long serviceId);

    /**
     * 重置服务号
     *
     * @param serviceId
     * @return
     */
    boolean resetService(Long serviceId);

    /**
     * 删除url
     *
     * @param urlId url的id
     * @return
     */
    boolean delUrl(Long urlId);

    /**
     * 添加url
     *
     * @param url
     * @param type      1：后端 2：Jssdk
     * @param serviceId 服务号Id
     * @return
     */
    boolean addUrl(String url, Long serviceId, Integer type) throws BizException;

    /**
     * 切换域名
     *
     * @param version   版本号 0:老 1：新
     * @param serviceId
     * @param type
     * @return
     */
    boolean changeUrl(Integer version, Long serviceId, Integer type) throws BizException;

    /**
     * 获取当前服务号配置
     *
     * @return
     */
    WechatUrlConfig getConfig();

    /**
     * 获取当前服务号配置
     *
     * @return
     */
    List<WechatUrlConfig> getConfigV2();

    /**
     * 查询url所有的配置
     */
    List<WechatUrlServiceConfig> getUrlConfigByUrl(String url);

    /**
     * 删除url，软删除
     *
     * @throws BizException 如果域名正在使用抛出异常
     */
    Boolean deleteByUrl(String url) throws BizException;

    /**
     * 依据serviceId查询url配置
     */
    List<WechatUrlDto> getUrlDtoByServiceIds(List<Long> serviceIds);

    /**
     * 依据serviceId查询公众号配置
     */
    List<WechatServiceDto> getServiceConfigByServiceIds(List<Long> serviceIds);

    /**
     * 管理端查询域名列表
     */
    List<WechatUrlDto> getUrlList(Integer urlStatus, Long serverId, String url);

    /**
     * 新域名管理保存域名配置的服务号
     */
    Boolean saveWechatUrl(String url, List<WechatUrlAddDto> wechatUrlAddDtos);

    /**
     * 自动切换域名
     *
     * @param url 被封域名
     * @return
     */
    Boolean switchDomain(String url);


    /**
     * 获取要巡检的域名列表
     * @return
     */
    List<String> getWechatCheckList();


}
