package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.NewsSettingConfigDto;

import java.util.List;

/**
 * description:  setting配置
 *
 * author: zhangrui
 * date: 2018/10/11 11:42
 */
@AdvancedFeignClient
public interface RemoteNewsSettingConfigService {

    /**
     * 批量更新
     * @param list
     * @return
     */
    boolean batchUpdate(List<NewsSettingConfigDto> list);

    /**
     * 获取
     * @param key
     * @return
     */
    /**
     * 通过key获取值
     * @param key
     * @return
     */
    String getValueByKey(String key);


    /**
     * 保存配置信息
     * @param keyName
     * @param keyContent
     * @return
     */
    int saveConfig(String keyName,String keyContent,Long id);

    /**
     * 查询分页列表
     * @param offset
     * @param max
     * @return
     */
    List<NewsSettingConfigDto> getListByParam(Integer offset,Integer max);

    /**
     * 查询分页数量
     * @param offset
     * @param max
     * @return
     */
    Integer getCountByParam(Integer offset,Integer max);


    /**
     * 获取系统配置，有缓存
     * @param key
     * @return
     */
    String getValueByKeyWithCache(String key);

}
