package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.AccountBalanceDto;
import cn.com.duiba.tuia.news.center.dto.AccountDetailDto;
import cn.com.duiba.tuia.news.center.dto.UserDailyIncomeCoinsDto;
import cn.com.duiba.tuia.news.center.dto.loginReward.LoginNewRewardDto;
import cn.com.duiba.tuia.news.center.dto.rsp.AccountBalanceV2Dto;

import java.util.List;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RemoteAccountService.java , v 0.1 2018/1/3 下午2:18 ZhouFeng Exp $
 */
@AdvancedFeignClient
public interface RemoteLoginRewardService {

    /**
     * 根据用户Id获取当前的任务进度和奖励
     * @param userId
     * @return
     */
    List<LoginNewRewardDto> getRewardListByUserId(Long userId);

    /**
     * 根据用户Id，奖励类型，任务新增数量增加任务完成度
     * @param userId
     * @param item
     * @param count
     * @return
     */
    boolean addPlan(Long userId,Integer item,Long count);


}
