package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.req.PageQueryResultDto;
import cn.com.duiba.tuia.news.center.dto.req.UserMessagePush;
import cn.com.duiba.tuia.news.center.dto.rsp.MessageCenterSystemDto;
import cn.com.duiba.tuia.news.center.dto.rsp.MessageCenterUserDto;

import java.util.List;
import java.util.Map;


/**
 * 消息中心的messageCenter
 * @author lichao 2018/11/27
 */
@AdvancedFeignClient
public interface RemoteMessageCenterService {

    /**
     * 查询系统消息
     * @return
     */
    List<MessageCenterSystemDto> systemList();


    /**
     * 查询用户通知
     * @param userId
     * @return
     */
    List<MessageCenterUserDto> userList(Long userId);

    /**
     * 给用户发送通知
     * @param userMessagePush
     * @return
     */
    boolean addUserMessage(UserMessagePush userMessagePush);



    /**
     * 查看系统公告详情
     */
    MessageCenterSystemDto selectById(Long id);

    /**
     * 获取消息列表数据
     * @param map
     * @return
     */
    PageQueryResultDto<MessageCenterSystemDto> listByParam(Map map);

    /**
     * 删除消息
     * @param id
     * @return
     */
    Boolean  deleteById(Long id);

    /**
     * 推送
     * @param id
     * @return
     */
    Boolean sendMessage(Long id);

    /**
     * 保存消息
     * @param dto
     * @return
     */
    Boolean saveMessage(MessageCenterSystemDto dto);


}
