package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.pdd.AppOrderListReq;
import cn.com.duiba.tuia.news.center.dto.pdd.GoodsOrderDto;
import cn.com.duiba.tuia.news.center.dto.pdd.PddManageReq;
import cn.com.duiba.tuia.news.center.dto.pdd.RollMsgDto;
import cn.com.duiba.tuia.news.center.dto.req.PageQueryResultDto;

import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2018/11/27 14:47
 * @Description:
 */
@AdvancedFeignClient
public interface RemotePDDService {

    String getPDDDidBy(Long userId);

    /**
     * 获取最新的50条获利记录
     * @return
     */
    List<RollMsgDto> getRollMsgDtoList();


    /**
     * 后台获取订单列表接口
     * @param pddManageReq
     * @return
     */
    PageQueryResultDto<GoodsOrderDto> getPage(PddManageReq pddManageReq);


    /**
     * 根据参数筛选订单列表
     * @param appOrderListReq
     * @return
     */
    List<GoodsOrderDto> getAppOrderList(AppOrderListReq appOrderListReq);

}
