package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * @Auther: wsz
 * @Date: 2018/8/30 10:06
 * @Description:
 */
public enum UserActionEnum {
    READING(1,"阅读"),
    ARTICLE_SHARE(2,"正文分享"),
    CONTACTS_RECORD(3,"通讯录记录")
    ;
    /**
     * 类型
     */
    private Integer type;
    /**
     * 描述
     */
    private String desc;

    private static final Map<Integer,UserActionEnum> CACHE = Maps.uniqueIndex(Arrays.asList(UserActionEnum.values()),UserActionEnum :: getType);
    UserActionEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static UserActionEnum getByType(Integer type) {
        return CACHE.get(type);
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
