package cn.com.duiba.tuia.news.center.enums;

import org.apache.commons.lang.math.RandomUtils;

/**
 * 1.6.2 之后的用户注册的用户使用的第一轮签到逻辑
 * @author lichao 2018/11/14
 */
public enum NewUserSignInRewardV6 implements SignInReward {

    DAY_ONE(1, 2,3, RewardUnit.CHANGE),

    DAY_TWO(2,2,3, RewardUnit.CHANGE),

    DAY_THREE(3, 2,3, RewardUnit.CHANGE),

    DAY_FOUR(4, 2,3, RewardUnit.CHANGE),

    DAY_FIVE(5,2,3, RewardUnit.CHANGE),

    DAY_SIX(6, 2,3, RewardUnit.CHANGE),

    DAY_SEVEN(7, 2,3,RewardUnit.CHANGE);

    private Integer             day;
    private Integer                rewardFeeMin;//随机的最小,不可小于1
    private Integer                rewardFeeMax;//随机的最大

    private RewardUnit          rewardUnit;

    NewUserSignInRewardV6(Integer day, Integer rewardFeeMin, Integer rewardFeeMax, RewardUnit rewardUnit) {
        this.day = day;
        this.rewardFeeMin = rewardFeeMin;
        this.rewardFeeMax = rewardFeeMax;
        this.rewardUnit = rewardUnit;
    }

    @Override
    public Long getRewardFee() {
        int i =  RandomUtils.nextInt(getRewardFeeMax()+1-getRewardFeeMin())+ getRewardFeeMin();
        return Long.valueOf(i);
    }


    @Override
    public Long getTopRewardNew() {
        //1.6.2 之后的用户没有最高的提示
        return null;
    }

    @Override
    public Integer getDay() {
        return day;
    }

    @Override
    public RewardUnit getRewardUnit() {
        return rewardUnit;
    }

    public void setDay(Integer day) {
        this.day = day;
    }

    public Integer getRewardFeeMin() {
        return rewardFeeMin;
    }

    public void setRewardFeeMin(Integer rewardFeeMin) {
        this.rewardFeeMin = rewardFeeMin;
    }

    public Integer getRewardFeeMax() {
        return rewardFeeMax;
    }

    public void setRewardFeeMax(Integer rewardFeeMax) {
        this.rewardFeeMax = rewardFeeMax;
    }

    public void setRewardUnit(RewardUnit rewardUnit) {
        this.rewardUnit = rewardUnit;
    }
}
