package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

public enum PacketRipeTimeEnum {

                            TEN_SECOUND(1, 10L),

                            TWENTY_SECOUND(2, 20L),

                            THIRTY_SECOUND(3, 30L),

                            ONE_MINUTE(4, 60L),

                            FIVE_MINUTE(5, 300L),

                            TEN_MINUTE(6, 600L),

                            FIFTEEN_MINUTE(7,900L),

                            TWENTY_MINUTE(8,1200L),

                            THIRTY_MINUTE(9,1800L),

                            ONE_HOUR(10,3600L),

                            THERE_HOUR(11,10800L),

                            SIX_HOUR(12,21600L),

                            EIGHT_HOUR(13,28800L);


    private Integer   ripeId;
    private Long ripeTime;

    private static final Map<Long, PacketRipeTimeEnum> CACHE = Maps.uniqueIndex(Arrays.asList(PacketRipeTimeEnum.values()),
            PacketRipeTimeEnum::getRipeTime);

    PacketRipeTimeEnum(Integer ripeId, Long ripeTime) {
        this.ripeId = ripeId;
        this.ripeTime = ripeTime;
    }

    public Integer getRipeId() {
        return ripeId;
    }

    public Long getRipeTime() {
        return ripeTime;
    }

    public static PacketRipeTimeEnum getByRipeTime(Long ripeTime) {
        PacketRipeTimeEnum packetRipeTimeEnum = CACHE.get(ripeTime);
        if (packetRipeTimeEnum != null) {
            return packetRipeTimeEnum;
        }
        return null;
    }

    public static PacketRipeTimeEnum getByRipeId(Integer ripeId) {
        for (PacketRipeTimeEnum packetRipeTimeEnum:PacketRipeTimeEnum.values()) {
            if(ripeId.equals(packetRipeTimeEnum.getRipeId())){
                return packetRipeTimeEnum;
            }
        }
        return null;
    }

    //去除10，20，30秒的特殊情况，特殊情况特殊判断
    public static Long getNextRipeTime(Long ripeTime){
        if(null == ripeTime){
            return ONE_MINUTE.getRipeTime();
        }
        PacketRipeTimeEnum packetRipeTimeEnum = getByRipeTime(ripeTime);
        if(packetRipeTimeEnum.getRipeId()<=12){
            return getByRipeId(packetRipeTimeEnum.getRipeId()+1).getRipeTime();
        }else {
            return EIGHT_HOUR.getRipeTime();
        }
    }
}
