package cn.com.duiba.tuia.news.center.enums;

/**
 * @author ElinZhou
 * @version $Id: WithdrawChannelType.java , v 0.1 2018/1/2 下午5:56 ElinZhou Exp $
 */
public enum WithdrawChannelType {

    /**
     * 支付宝人工
     */
    ALIPAY_MANUAL(1, "支付宝人工","支付宝"),
    ALIPAY_SYSTEM(2," 支付宝系统","支付宝"),
    ALIPAY_USER(3,"支付宝账号","支付宝"),
    WHCHAT_USER(4,"微信账号","微信")

    ;

    private Integer code;
    private String desc;
    private String showName;

    WithdrawChannelType(Integer code,String desc,String showName) {
        this.code = code;
        this.desc = desc;
        this.showName = showName;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public static WithdrawChannelType of(Integer aCode) {
        if (aCode == null) {
            return null;
        }
        for (WithdrawChannelType withdrawChannelType : values()) {
            if (withdrawChannelType.getCode().equals(aCode)) {
                return withdrawChannelType;
            }
        }
        return null;
    }

    public boolean same(Integer other) {
        if (other == null) {
            return false;
        }
        return code.equals(other);

    }

    public String getShowName() {
        return showName;
    }

    public void setShowName(String showName) {
        this.showName = showName;
    }
}
