package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * Created by xiaotian on 2018/6/21.
 */
@AdvancedFeignClient
public interface RemoteDogService {

    /**
     * 获取看门狗
     * @param userId
     * @return
     */
    boolean getDog(Long userId);

    /**
     * 判断狗是否有效
     * @param userId
     * @return
     */
    boolean dogVaild(Long userId);

    /**
     * 自己曝光狗狗
     * @param userId
     * @return
     */
    boolean exposureDog(Long userId);


    /**
     * 获取打狗棒
     * @param userId
     * @return
     */
    boolean getStick(Long userId);

    /**
     * 使用打狗棒
     * @param userId
     * @return
     */
    boolean useStick(Long userId);

    /**
     * 获取打狗棒的数量
     * @param userId
     * @return
     */
    Long getStickAmount(Long userId);


    /**
     * 击打狗
     * @param beatUserId
     * @param dogUserId
     * @return
     */
    boolean beatDog(Long beatUserId,Long dogUserId);


    /**
     * 获取小狗的说的话
     * @return
     */
    Map<Integer,Map<Integer,List<String>>> getDogLanguage();

    /**
     * 获取道具
     * @param userId
     * @return
     */
    Integer getProp(Long userId,String newsId,Integer taskId);
}
