package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.AssisDoubleDto;
import cn.com.duiba.tuia.news.center.dto.AssisPageDto;
import cn.com.duiba.tuia.news.center.dto.PacketDoubleDto;
import cn.com.duiba.tuia.news.center.dto.Response.NewLandOperateDto;
import cn.com.duiba.tuia.news.center.dto.landtools.AssisSuccessDto;
import cn.com.duiba.tuia.news.center.dto.landtools.LandToolsDto;
import cn.com.duiba.tuia.news.center.dto.req.*;

import java.util.List;

/**
 * Created by xiaotian on 2018/5/8.
 * @author xiaotian
 */
@AdvancedFeignClient
public interface RemoteNewLandService {

    /**
     * 初始化土地
     * @param userId
     * @return
     */
    boolean init(Long userId);

    /**
     * 初始化土地
     * @param newLandInitReq
     * @return
     */
    boolean initV2(NewLandInitReq newLandInitReq);

    /**
     * 获取土地状况（附加土地上的红包的种植情况和成熟情况）
     */
    FarmDto getLandCondition(Long userId) throws BizException;


    /**
     * 获取土地状况（附加土地上的红包的种植情况和成熟情况）
     */
    FarmDto getLandConditionForOther(Long userId,Long other,Integer type) throws BizException;

    /**
     * 获取当前任务完成进度
     * @param userId
     * @return
     */
    LandTaskDto getPresentTask(Long userId);

    /**
     * 对土地的操作
     * @param userId
     * @param LandId
     * @return
     */
    NewLandOperateDto commonOperate(Long userId, Long LandId) throws BizException;

    /**
     * 好玩通用红点推送
     * @param userId
     * @return
     */
    boolean nomalRedPointPush(Long userId);

    /**
     * 记录阅读时长
     * @param userId
     * @param time
     * @return
     */
    boolean uploadReadTime(Long userId,Long time);


    /**
     * 申请好友
     * @param applyId
     * @param userId
     * @return
     */
    boolean applyFriend(Long applyId,Long userId) throws BizException;


    /**
     * 处理好友申请
     * @param applyId
     * @param userId
     * @param applyRelationType
     * @return
     */
    boolean dealApply(Long applyId, Long userId, Integer applyRelationType);


    /**
     * 获取待处理的好友申请
     * @param userId
     * @return
     */
    List<FriendDto> getWaitList(Long userId);

    /**
     * 添加仇敌
     * @param userId
     * @param enemyId
     * @return
     */
    boolean addEnemy(Long userId,Long enemyId);

    /**
     * @param stealId 偷取者Id
     * @param userId 偷取谁的牧场红包
     * @param type 0：狗狗被打晕 1：狗狗醒着
     * @return
     */
    OperateStealDto steal(Long stealId,Long userId,Long landId,Integer type) throws BizException;


    /**
     * 分页获取好友列表
     * @param userId
     * @param page
     * @param pageSize
     * @return
     */
    List<FriendDto> getFriendList(Long userId,Integer page,Integer pageSize);


    /**
     * 分页获取仇敌列表
     * @param userId
     * @param page
     * @param pageSize
     * @return
     */
    List<EnemyDto> getEnemyList(Long userId, Integer page, Integer pageSize);


    /**
     * 获取陌生人列表
     * @param userId
     * @return
     */
    List<StrangerDto> getStrangerList(Long userId) throws BizException;


    /**
     * 获取陌生人列表
     * @param userId
     * @return
     */
    RefreshStrangerDto refreshStrangerList(Long userId) throws BizException;


    /**
     * 开启土地
     * @param userId
     * @param taskId
     * @return
     */
    Long openLand(Long userId, Integer taskId);


    /**
     * 是否初始化过1.4.0版本的土地
     * @param userId
     * @return
     */
    boolean alreadyInit(Long userId);


    /**
     * 首次绑定翻倍卡
     */
    void binDingDoubleCard(PacketDoubleDto packetDoubleDto) throws BizException;

    /**
     * 获取助力成员列表
     */
    AssisPageDto getAssistList(Long doubleId ,Long userID);


    /**
     * 助力翻倍红包
     */

    void  assistDoubleCard(AssisDoubleDto assisDoubleDto) throws BizException;


    /**
     * 获取有效的翻倍卡id
     */
    LandToolsDto getLandTools(Long userId);

    /**
     * 根据code返回微信uuid
     */
    AssisSuccessDto getAssisSuccessInfo(String code) throws BizException;


}
