package cn.com.duiba.tuia.news.center.dto;

import cn.com.duiba.tuia.news.center.enums.RewardTimeUnit;
import cn.com.duiba.tuia.news.center.enums.RewardUnit;

import java.io.Serializable;
import java.util.Date;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RewardTaskDto.java , v 0.1 2018/1/3 下午7:20 ZhouFeng Exp $
 */
public class RewardTaskDto implements Serializable {

    private static final long serialVersionUID = 4998548577378003283L;
    /**
     * 任务id
     */
    private Long id;
    /**
     * 奖励数量
     */
    private Long rewardCount;

    /**
     * 奖励单位
     */
    private RewardUnit rewardUnit;

    /***
     * 最大领奖次数
     */
    private Long maxTimes;

    /**
     * 最大领奖次数时间单位
     */
    private RewardTimeUnit maxTimesUnit;

    /**
     * 任务描述
     */
    private String taskDesc;

    /**
     * 任务创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getRewardCount() {
        return rewardCount;
    }

    public void setRewardCount(Long rewardCount) {
        this.rewardCount = rewardCount;
    }

    public RewardUnit getRewardUnit() {
        return rewardUnit;
    }

    public void setRewardUnit(RewardUnit rewardUnit) {
        this.rewardUnit = rewardUnit;
    }

    public Long getMaxTimes() {
        return maxTimes;
    }

    public void setMaxTimes(Long maxTimes) {
        this.maxTimes = maxTimes;
    }

    public RewardTimeUnit getMaxTimesUnit() {
        return maxTimesUnit;
    }

    public void setMaxTimesUnit(RewardTimeUnit maxTimesUnit) {
        this.maxTimesUnit = maxTimesUnit;
    }

    public String getTaskDesc() {
        return taskDesc;
    }

    public void setTaskDesc(String taskDesc) {
        this.taskDesc = taskDesc;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
